/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMArrivalPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class VWSIMCustomArrivalPanel
extends VWSIMArrivalPanel
implements ActionListener,
DocumentListener {
    private static final String DIST_UNIFORM_PREFIX = "dist_uniform(0,";
    private VWToolbarBorder m_startTimeBorder = null;
    private JRadioButton m_sameStartTimeRadioButton = null;
    private JRadioButton m_startDateRadioButton = null;
    private JTextField m_startDateTextField = null;
    private JTextField m_startTimeTextField = null;
    private JButton m_startCalendarButton = null;
    private VWToolbarBorder m_endTimeBorder = null;
    private JRadioButton m_noEndTimeRadioButton = null;
    private JRadioButton m_endDateRadioButton = null;
    private JTextField m_endDateTextField = null;
    private JTextField m_endTimeTextField = null;
    private JButton m_endCalendarButton = null;
    private VWToolbarBorder m_occurrenceBorder = null;
    private JLabel m_quantityLabel = null;
    private VWNumericTextField m_quantityTextField = null;
    private JRadioButton m_eachIntervalRadioButton = null;
    private VWNumericTextField m_intervalTextField = null;
    private JComboBox m_intervalComboBox = null;
    private JRadioButton m_distributedOverRadioButton = null;
    private VWNumericTextField m_distributedTextField = null;
    private JComboBox m_distributedComboBox = null;
    private GridBagConstraints m_gridCons = null;
    private VWScenarioArrivalDefinition m_arrivalDef = null;
    private VWSIMPropertyData m_propertyData = null;

    public VWSIMCustomArrivalPanel(VWSIMPropertyData propertyData) {
        super(propertyData);
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gridCons = new GridBagConstraints();
        this.initStartTimeControls();
        this.initEndTimeControls();
        this.initOccurrenceControls();
    }

    public void setArrivalDefinition(VWSIMPropertyData propertyData, VWScenarioArrivalDefinition arrivalDef) {
        this.m_propertyData = propertyData;
        this.m_arrivalDef = arrivalDef;
        this.reinitialize();
    }

    public void enablePropertyPanel(boolean enable) {
        this.m_sameStartTimeRadioButton.setEnabled(enable);
        this.m_startDateRadioButton.setEnabled(enable);
        this.m_startDateTextField.setEnabled(enable);
        this.m_startTimeTextField.setEnabled(enable);
        this.m_startCalendarButton.setEnabled(enable);
        this.m_noEndTimeRadioButton.setEnabled(enable);
        this.m_endDateRadioButton.setEnabled(enable);
        this.m_endDateTextField.setEnabled(enable);
        this.m_endDateTextField.setEnabled(enable);
        this.m_endCalendarButton.setEnabled(enable);
        this.m_quantityLabel.setEnabled(enable);
        this.m_quantityTextField.setEnabled(enable);
        this.m_eachIntervalRadioButton.setEnabled(enable);
        this.m_intervalTextField.setEnabled(enable);
        this.m_intervalComboBox.setEnabled(enable);
        this.m_distributedOverRadioButton.setEnabled(enable);
        this.m_distributedTextField.setEnabled(enable);
        this.m_distributedComboBox.setEnabled(enable);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_sameStartTimeRadioButton) {
            this.performSameAsStartTimeRadioButton();
        } else if (src == this.m_startDateRadioButton) {
            this.performStartDateRadioButton();
        } else if (src == this.m_noEndTimeRadioButton) {
            this.performNoEndTimeRadioButton();
        } else if (src == this.m_endDateRadioButton) {
            this.performEndDateRadioButton();
        } else if (src == this.m_eachIntervalRadioButton) {
            this.performEachIntervalRadioButton();
        } else if (src == this.m_distributedOverRadioButton) {
            this.performDistributedOverRadioButton();
        } else if (src == this.m_intervalComboBox) {
            this.performIntervalComboBox();
        } else if (src == this.m_distributedComboBox) {
            this.performDistributedComboBox();
        } else if (src == this.m_startCalendarButton) {
            this.performStartCalendarButtonAction();
        } else if (src == this.m_endCalendarButton) {
            this.performEndCalendarButtonAction();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_quantityTextField.getDocument()) {
            this.updateQuantityTextField();
        } else if (doc == this.m_intervalTextField.getDocument()) {
            this.updateIntervalTextField();
        } else if (doc == this.m_distributedTextField.getDocument()) {
            this.updateDistributedTextField();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void initStartTimeControls() {
        try {
            this.m_startTimeBorder = new VWToolbarBorder(VWSIMResource.s_startDateTime);
            JPanel clientPanel = this.m_startTimeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 3;
            gbCons.gridheight = 1;
            this.m_sameStartTimeRadioButton = new JRadioButton(VWSIMResource.s_sameAsScenarioStartTime);
            this.m_sameStartTimeRadioButton.setEnabled(false);
            this.m_sameStartTimeRadioButton.setSelected(true);
            this.m_sameStartTimeRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_sameStartTimeRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(-5, 0, 0, 0);
            this.m_startDateRadioButton = new JRadioButton(VWSIMResource.s_dateTime);
            this.m_startDateRadioButton.setEnabled(false);
            this.m_startDateRadioButton.setSelected(false);
            this.m_startDateRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_startDateRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_startDateTextField = new JTextField();
            this.m_startDateTextField.setEnabled(false);
            this.m_startDateTextField.setEditable(false);
            clientPanel.add((Component)this.m_startDateTextField, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_startTimeTextField = new JTextField();
            this.m_startTimeTextField.setEnabled(false);
            this.m_startTimeTextField.setEditable(false);
            clientPanel.add((Component)this.m_startTimeTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            this.m_startCalendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_startCalendarButton.setEnabled(false);
            this.m_startCalendarButton.addActionListener(this);
            clientPanel.add((Component)this.m_startCalendarButton, gbCons);
            buttonGroup.add(this.m_sameStartTimeRadioButton);
            buttonGroup.add(this.m_startDateRadioButton);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 0;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 0.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_startTimeBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initEndTimeControls() {
        try {
            this.m_endTimeBorder = new VWToolbarBorder(VWSIMResource.s_endDateTime);
            JPanel clientPanel = this.m_endTimeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 3;
            gbCons.gridheight = 1;
            this.m_noEndTimeRadioButton = new JRadioButton(VWSIMResource.s_noEndTime);
            this.m_noEndTimeRadioButton.setEnabled(false);
            this.m_noEndTimeRadioButton.setSelected(true);
            this.m_noEndTimeRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_noEndTimeRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(-5, 0, 0, 0);
            this.m_endDateRadioButton = new JRadioButton(VWSIMResource.s_dateTime);
            this.m_endDateRadioButton.setEnabled(false);
            this.m_endDateRadioButton.setSelected(false);
            this.m_endDateRadioButton.addActionListener(this);
            clientPanel.add((Component)this.m_endDateRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_endDateTextField = new JTextField();
            this.m_endDateTextField.setEnabled(false);
            this.m_endDateTextField.setEditable(false);
            clientPanel.add((Component)this.m_endDateTextField, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_endTimeTextField = new JTextField();
            this.m_endTimeTextField.setEnabled(false);
            this.m_endTimeTextField.setEditable(false);
            clientPanel.add((Component)this.m_endTimeTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_endCalendarButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_endCalendarButton.setEnabled(false);
            this.m_endCalendarButton.addActionListener(this);
            clientPanel.add((Component)this.m_endCalendarButton, gbCons);
            buttonGroup.add(this.m_noEndTimeRadioButton);
            buttonGroup.add(this.m_endDateRadioButton);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 1;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 0.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 0, 5);
            this.add((Component)this.m_endTimeBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initOccurrenceControls() {
        try {
            this.m_occurrenceBorder = new VWToolbarBorder(VWSIMResource.s_occurrence);
            JPanel clientPanel = this.m_occurrenceBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(2, 0, 0, 0);
            this.m_quantityLabel = new JLabel(VWSIMResource.s_quantity);
            clientPanel.add((Component)this.m_quantityLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_quantityTextField = new VWNumericTextField(4, 0, false);
            this.m_quantityTextField.setEnabled(false);
            this.m_quantityTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_quantityTextField, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(-2, 0, 0, 0);
            this.m_eachIntervalRadioButton = new JRadioButton(VWSIMResource.s_eachInterval);
            this.m_eachIntervalRadioButton.setEnabled(false);
            this.m_eachIntervalRadioButton.setSelected(true);
            this.m_eachIntervalRadioButton.addActionListener(this);
            buttonGroup.add(this.m_eachIntervalRadioButton);
            clientPanel.add((Component)this.m_eachIntervalRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(3, 0, 0, 0);
            this.m_intervalTextField = new VWNumericTextField(4, 0, false);
            this.m_intervalTextField.setEnabled(false);
            this.m_intervalTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_intervalTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_intervalComboBox = new JComboBox();
            this.m_intervalComboBox.addItem(VWSIMResource.s_seconds);
            this.m_intervalComboBox.addItem(VWSIMResource.s_minutes);
            this.m_intervalComboBox.addItem(VWSIMResource.s_hours);
            this.m_intervalComboBox.addItem(VWSIMResource.s_days);
            this.m_intervalComboBox.addItem(VWSIMResource.s_weeks);
            this.m_intervalComboBox.addItem(VWSIMResource.s_months);
            this.m_intervalComboBox.setSelectedItem(VWSIMResource.s_hours);
            this.m_intervalComboBox.setEnabled(false);
            this.m_intervalComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_intervalComboBox.addActionListener(this);
            clientPanel.add((Component)this.m_intervalComboBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.insets = new Insets(-2, 0, 0, 0);
            this.m_distributedOverRadioButton = new JRadioButton(VWSIMResource.s_distributedOver);
            this.m_distributedOverRadioButton.setEnabled(false);
            this.m_distributedOverRadioButton.setSelected(false);
            this.m_distributedOverRadioButton.addActionListener(this);
            buttonGroup.add(this.m_distributedOverRadioButton);
            clientPanel.add((Component)this.m_distributedOverRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(3, 0, 0, 0);
            this.m_distributedTextField = new VWNumericTextField(4, 0, false);
            this.m_distributedTextField.setEnabled(false);
            this.m_distributedTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_distributedTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 3, 0, 0);
            this.m_distributedComboBox = new JComboBox();
            this.m_distributedComboBox.addItem(VWSIMResource.s_seconds);
            this.m_distributedComboBox.addItem(VWSIMResource.s_minutes);
            this.m_distributedComboBox.addItem(VWSIMResource.s_hours);
            this.m_distributedComboBox.addItem(VWSIMResource.s_days);
            this.m_distributedComboBox.addItem(VWSIMResource.s_weeks);
            this.m_distributedComboBox.addItem(VWSIMResource.s_months);
            this.m_distributedComboBox.setSelectedItem(VWSIMResource.s_hours);
            this.m_distributedComboBox.setEnabled(false);
            this.m_distributedComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_distributedComboBox.addActionListener(this);
            clientPanel.add((Component)this.m_distributedComboBox, gbCons);
            this.m_gridCons.gridx = 0;
            this.m_gridCons.gridy = 2;
            this.m_gridCons.fill = 2;
            this.m_gridCons.weightx = 1.0;
            this.m_gridCons.weighty = 1.0;
            this.m_gridCons.anchor = 23;
            this.m_gridCons.gridwidth = 1;
            this.m_gridCons.gridheight = 1;
            this.m_gridCons.insets = new Insets(5, 0, 5, 5);
            this.add((Component)this.m_occurrenceBorder, this.m_gridCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSameAsStartTimeRadioButton() {
        try {
            this.m_startDateTextField.setText("");
            this.m_startDateTextField.setEnabled(false);
            this.m_startTimeTextField.setText("");
            this.m_startTimeTextField.setEnabled(false);
            this.m_startCalendarButton.setEnabled(false);
            this.m_arrivalDef.setStartTime(new VWScenarioTimeDuration("0", 3));
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performStartDateRadioButton() {
        try {
            this.m_startTimeTextField.setEnabled(true);
            this.m_startDateTextField.setEnabled(true);
            this.m_startCalendarButton.setEnabled(true);
            Date startDateTime = (Date)this.m_propertyData.getScenarioDefinition().getStartTime();
            this.m_arrivalDef.setStartTime(startDateTime);
            this.m_propertyData.setDirty();
            String dateString = VWDateTimeFormat.getDateString(startDateTime);
            String timeString = VWDateTimeFormat.getTimeString(startDateTime);
            this.m_startDateTextField.setText(dateString);
            this.m_startTimeTextField.setText(timeString);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performStartCalendarButtonAction() {
        String initDateString = this.m_startDateTextField.getText();
        String initTimeString = this.m_startTimeTextField.getText();
        VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
        calendarDlg.setVisible(true);
        int status = calendarDlg.getCloseStatus();
        if (status == 1) {
            Date date = calendarDlg.getDate();
            String dateString = VWDateTimeFormat.getDateString(date);
            String timeString = VWDateTimeFormat.getTimeString(date);
            this.m_startDateTextField.setText(dateString);
            this.m_startTimeTextField.setText(timeString);
            try {
                this.m_arrivalDef.setStartTime(date);
                this.m_propertyData.setDirty();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void performNoEndTimeRadioButton() {
        try {
            this.m_endDateTextField.setText("");
            this.m_endDateTextField.setEnabled(false);
            this.m_endTimeTextField.setText("");
            this.m_endTimeTextField.setEnabled(false);
            this.m_endCalendarButton.setEnabled(false);
            this.m_arrivalDef.getOccurrence().setEndTime(null);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performEndDateRadioButton() {
        try {
            this.m_endDateTextField.setEnabled(true);
            this.m_endTimeTextField.setEnabled(true);
            this.m_endCalendarButton.setEnabled(true);
            Date endDateTime = (Date)this.m_propertyData.getScenarioDefinition().getEndTime();
            this.m_arrivalDef.getOccurrence().setEndTime(endDateTime);
            this.m_propertyData.setDirty();
            String dateString = VWDateTimeFormat.getDateString(endDateTime);
            String timeString = VWDateTimeFormat.getTimeString(endDateTime);
            this.m_endDateTextField.setText(dateString);
            this.m_endTimeTextField.setText(timeString);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performEndCalendarButtonAction() {
        String initDateString = this.m_endDateTextField.getText();
        String initTimeString = this.m_endTimeTextField.getText();
        VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 102, initDateString + " " + initTimeString);
        calendarDlg.setVisible(true);
        int status = calendarDlg.getCloseStatus();
        if (status == 1) {
            Date date = calendarDlg.getDate();
            String dateString = VWDateTimeFormat.getDateString(date);
            String timeString = VWDateTimeFormat.getTimeString(date);
            this.m_endDateTextField.setText(dateString);
            this.m_endTimeTextField.setText(timeString);
            VWScenarioArrivalOccurrence occurrence = this.m_arrivalDef.getOccurrence();
            if (occurrence != null) {
                occurrence.setEndTime(date);
                this.m_propertyData.setDirty();
            }
        }
    }

    private void updateQuantityTextField() {
        try {
            try {
                VWScenarioArrivalOccurrence occurrence;
                if (this.m_arrivalDef != null && (occurrence = this.m_arrivalDef.getOccurrence()) != null) {
                    occurrence.setQuantity(this.m_quantityTextField.getText());
                    this.m_propertyData.setDirty();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performEachIntervalRadioButton() {
        try {
            block5: {
                try {
                    int nIndex;
                    this.m_intervalTextField.setEnabled(true);
                    this.m_intervalComboBox.setEnabled(true);
                    this.m_distributedTextField.getDocument().removeDocumentListener(this);
                    this.m_distributedTextField.setText("");
                    this.m_distributedTextField.setEnabled(false);
                    this.m_distributedComboBox.setEnabled(false);
                    this.m_arrivalDef.getOccurrence().setType(1);
                    VWScenarioTimeDuration interval = (VWScenarioTimeDuration)this.m_arrivalDef.getOccurrence().getTimeInterval();
                    if (interval == null) break block5;
                    String duration = interval.getDuration();
                    if (duration != null && duration.length() > 0 && duration.startsWith(DIST_UNIFORM_PREFIX) && (duration = duration.substring(DIST_UNIFORM_PREFIX.length())) != null && duration.length() > 0 && (nIndex = duration.indexOf(")")) != -1) {
                        duration = duration.substring(0, nIndex);
                    }
                    this.m_intervalTextField.setText(duration);
                    this.setUnitComboBox(this.m_intervalComboBox, interval.getUnits(), this);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var5_6 = null;
                    this.m_distributedTextField.getDocument().addDocumentListener(this);
                }
            }
            Object var5_5 = null;
            this.m_distributedTextField.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_distributedTextField.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    private void updateIntervalTextField() {
        try {
            try {
                VWScenarioArrivalOccurrence occurrence;
                if (this.m_arrivalDef != null && (occurrence = this.m_arrivalDef.getOccurrence()) != null) {
                    VWScenarioTimeDuration duration = (VWScenarioTimeDuration)occurrence.getTimeInterval();
                    duration.setDuration(this.m_intervalTextField.getText());
                    this.m_propertyData.setDirty();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performIntervalComboBox() {
        try {
            int unit = this.getUnitComboBoxValue(this.m_intervalComboBox);
            ((VWScenarioTimeDuration)this.m_arrivalDef.getOccurrence().getTimeInterval()).setUnits(unit);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDistributedOverRadioButton() {
        try {
            block4: {
                try {
                    this.m_intervalTextField.getDocument().removeDocumentListener(this);
                    this.m_intervalTextField.setText("");
                    this.m_intervalTextField.setEnabled(false);
                    this.m_intervalComboBox.setEnabled(false);
                    this.m_distributedTextField.setEnabled(true);
                    this.m_distributedComboBox.setEnabled(true);
                    this.m_arrivalDef.getOccurrence().setType(2);
                    VWScenarioTimeDuration interval = (VWScenarioTimeDuration)this.m_arrivalDef.getOccurrence().getTimeInterval();
                    if (interval == null) break block4;
                    this.m_distributedTextField.setText(interval.getDuration());
                    this.setUnitComboBox(this.m_distributedComboBox, interval.getUnits(), this);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var3_4 = null;
                    this.m_intervalTextField.getDocument().addDocumentListener(this);
                }
            }
            Object var3_3 = null;
            this.m_intervalTextField.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.m_intervalTextField.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    private void updateDistributedTextField() {
        try {
            VWScenarioArrivalOccurrence occurrence;
            if (this.m_arrivalDef != null && (occurrence = this.m_arrivalDef.getOccurrence()) != null) {
                VWScenarioTimeDuration duration = (VWScenarioTimeDuration)occurrence.getTimeInterval();
                duration.setDuration(DIST_UNIFORM_PREFIX + this.m_distributedTextField.getText() + ")");
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDistributedComboBox() {
        try {
            int unit = this.getUnitComboBoxValue(this.m_distributedComboBox);
            ((VWScenarioTimeDuration)this.m_arrivalDef.getOccurrence().getTimeInterval()).setUnits(unit);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reinitialize() {
        if (this.m_arrivalDef != null) {
            this.enablePropertyPanel(true);
            Object startTime = this.m_arrivalDef.getStartTime();
            VWScenarioArrivalOccurrence occurrence = this.m_arrivalDef.getOccurrence();
            if (startTime != null) {
                if (startTime instanceof VWScenarioTimeDuration) {
                    this.m_sameStartTimeRadioButton.removeActionListener(this);
                    this.m_sameStartTimeRadioButton.setSelected(true);
                    this.m_sameStartTimeRadioButton.addActionListener(this);
                    this.m_startDateTextField.setText("");
                    this.m_startDateTextField.setEnabled(false);
                    this.m_startTimeTextField.setText("");
                    this.m_startTimeTextField.setEnabled(false);
                    this.m_startCalendarButton.setEnabled(false);
                } else if (startTime instanceof Date) {
                    Date startDateTime = (Date)startTime;
                    this.m_startDateTextField.setText(VWDateTimeFormat.getDateString(startDateTime));
                    this.m_startTimeTextField.setText(VWDateTimeFormat.getTimeString(startDateTime));
                    this.m_startDateRadioButton.removeActionListener(this);
                    this.m_startDateRadioButton.setSelected(true);
                    this.m_startDateRadioButton.addActionListener(this);
                    this.m_startDateTextField.setEnabled(true);
                    this.m_startTimeTextField.setEnabled(true);
                    this.m_startCalendarButton.setEnabled(true);
                }
            }
            if (occurrence == null) return;
            Object endTime = occurrence.getEndTime();
            String quantity = occurrence.getQuantity();
            VWScenarioTimeDuration interval = (VWScenarioTimeDuration)occurrence.getTimeInterval();
            if (endTime == null) {
                this.m_noEndTimeRadioButton.removeActionListener(this);
                this.m_noEndTimeRadioButton.setSelected(true);
                this.m_noEndTimeRadioButton.addActionListener(this);
                this.m_endDateTextField.setText("");
                this.m_endDateTextField.setEnabled(false);
                this.m_endTimeTextField.setText("");
                this.m_endTimeTextField.setEnabled(false);
                this.m_endCalendarButton.setEnabled(false);
            } else {
                Date endDateTime = (Date)endTime;
                this.m_endDateTextField.setText(VWDateTimeFormat.getDateString(endDateTime));
                this.m_endTimeTextField.setText(VWDateTimeFormat.getTimeString(endDateTime));
                this.m_endDateRadioButton.removeActionListener(this);
                this.m_endDateRadioButton.setSelected(true);
                this.m_endDateRadioButton.addActionListener(this);
                this.m_endDateTextField.setEnabled(true);
                this.m_endTimeTextField.setEnabled(true);
                this.m_endCalendarButton.setEnabled(true);
            }
            this.m_quantityTextField.setEnabled(true);
            this.m_quantityTextField.getDocument().removeDocumentListener(this);
            this.m_quantityTextField.setText(quantity);
            this.m_quantityTextField.getDocument().addDocumentListener(this);
            switch (occurrence.getType()) {
                case 1: {
                    try {
                        try {
                            this.m_eachIntervalRadioButton.removeActionListener(this);
                            this.m_intervalTextField.getDocument().removeDocumentListener(this);
                            this.m_distributedTextField.getDocument().removeDocumentListener(this);
                            this.m_eachIntervalRadioButton.setSelected(true);
                            this.m_intervalTextField.setText(interval.getDuration());
                            this.setUnitComboBox(this.m_intervalComboBox, interval.getUnits(), this);
                            this.m_distributedTextField.setText("");
                            this.m_distributedTextField.setEnabled(false);
                            this.m_distributedComboBox.setEnabled(false);
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            Object var8_11 = null;
                            this.m_eachIntervalRadioButton.addActionListener(this);
                            this.m_intervalTextField.getDocument().addDocumentListener(this);
                            this.m_distributedTextField.getDocument().addDocumentListener(this);
                            return;
                        }
                        Object var8_10 = null;
                        this.m_eachIntervalRadioButton.addActionListener(this);
                        this.m_intervalTextField.getDocument().addDocumentListener(this);
                        this.m_distributedTextField.getDocument().addDocumentListener(this);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        this.m_eachIntervalRadioButton.addActionListener(this);
                        this.m_intervalTextField.getDocument().addDocumentListener(this);
                        this.m_distributedTextField.getDocument().addDocumentListener(this);
                        throw throwable;
                    }
                }
                case 2: {
                    try {
                        try {
                            this.m_distributedOverRadioButton.removeActionListener(this);
                            this.m_intervalTextField.getDocument().removeDocumentListener(this);
                            this.m_distributedTextField.getDocument().removeDocumentListener(this);
                            this.m_intervalTextField.setText("");
                            this.m_intervalTextField.setEnabled(false);
                            this.m_intervalComboBox.setEnabled(false);
                            this.m_distributedOverRadioButton.setSelected(true);
                            String distribution = interval.getDuration();
                            if (distribution != null) {
                                int nCommaIndex = distribution.indexOf(",");
                                int nEndIndex = distribution.length() - 1;
                                if (nCommaIndex != -1 && nEndIndex != -1) {
                                    distribution = distribution.substring(nCommaIndex + 1, nEndIndex);
                                    this.m_distributedTextField.setText(distribution);
                                }
                            }
                            this.setUnitComboBox(this.m_distributedComboBox, interval.getUnits(), this);
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            Object var10_17 = null;
                            this.m_distributedOverRadioButton.addActionListener(this);
                            this.m_intervalTextField.getDocument().addDocumentListener(this);
                            this.m_distributedTextField.getDocument().addDocumentListener(this);
                            return;
                        }
                        Object var10_16 = null;
                        this.m_distributedOverRadioButton.addActionListener(this);
                        this.m_intervalTextField.getDocument().addDocumentListener(this);
                        this.m_distributedTextField.getDocument().addDocumentListener(this);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        this.m_distributedOverRadioButton.addActionListener(this);
                        this.m_intervalTextField.getDocument().addDocumentListener(this);
                        this.m_distributedTextField.getDocument().addDocumentListener(this);
                        throw throwable;
                    }
                }
            }
            return;
        }
        try {
            try {
                this.m_quantityTextField.getDocument().removeDocumentListener(this);
                this.m_intervalTextField.getDocument().removeDocumentListener(this);
                this.m_distributedTextField.getDocument().removeDocumentListener(this);
                this.enablePropertyPanel(false);
                this.m_startDateTextField.setText("");
                this.m_startTimeTextField.setText("");
                this.m_endDateTextField.setText("");
                this.m_endTimeTextField.setText("");
                this.m_quantityTextField.setText("");
                this.m_intervalTextField.setText("");
                this.m_distributedTextField.setText("");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var12_21 = null;
                this.m_quantityTextField.getDocument().addDocumentListener(this);
                this.m_intervalTextField.getDocument().addDocumentListener(this);
                this.m_distributedTextField.getDocument().addDocumentListener(this);
                return;
            }
            Object var12_20 = null;
            this.m_quantityTextField.getDocument().addDocumentListener(this);
            this.m_intervalTextField.getDocument().addDocumentListener(this);
            this.m_distributedTextField.getDocument().addDocumentListener(this);
            return;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            this.m_quantityTextField.getDocument().addDocumentListener(this);
            this.m_intervalTextField.getDocument().addDocumentListener(this);
            this.m_distributedTextField.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }
}

